/***************************************************************************
 Copyright (c) 2009 Stephen Roderick <xxxstephen AT theptrgroupxxx DOT comxxx>
                                             (remove the x's above)

 ***************************************************************************
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place,                                    *
 *   Suite 330, Boston, MA  02111-1307  USA                                *
 *                                                                         *
 ***************************************************************************/

/** \file SimpleNonPeriodicClient.hpp
	A simple TCP client using a non-periodic component.
*/

#ifndef	__SIMPLENONPERIODICCLIENT_HPP
#define	__SIMPLENONPERIODICCLIENT_HPP 1

#include <rtt/TaskContext.hpp>
#include <rtt/Ports.hpp>
#include <rtt/Attribute.hpp>
#include <string>

// forward declare to avoid preprocessor issues with some Qt stuff
class QTcpSocket;

/** Connect to a remote TCP socket and read and print all arriving data
 */
class SimpleNonPeriodicClient : public RTT::TaskContext
{
protected:
	// DATA INTERFACE

	// *** OUTPUTS ***

	/// the last read data
	RTT::WriteDataPort<std::string>			lastRead_port;
	
	/// the number of items sucessfully read
	RTT::Attribute<int>						countRead_attr;

	// *** CONFIGURATION ***

	// name to listen for incoming connections on, either FQDN or IPv4 addres
	RTT::Property<std::string>				hostName_prop;
	// port to listen on
	RTT::Property<int>						hostPort_prop;
	// timeout in seconds, when waiting for connection
	RTT::Property<int>						connectionTimeout_prop;
	// timeout in seconds, when waiting to read
	RTT::Property<int>						readTimeout_prop;
	
public:
	SimpleNonPeriodicClient(std::string name);
	virtual ~SimpleNonPeriodicClient();

protected:
	/// reset count and lastRead, attempt to connect to remote
	virtual bool startHook();
	/// attempt to read and process one packet
	virtual void updateHook();
	/// close the socket and cleanup
	virtual void stopHook();
	/// cause updateHook() to return
	virtual bool breakUpdateHook();

	/// Socket used to connect to remote host
	QTcpSocket*	socket;
	/// Flag indicating to updateHook() that we want to quit
	bool		quit;
};

#endif
